primitive U_FT_P_SB_RB_NO (Q, CP, RB, SB, NOTIFIER_REG); 




    output Q; 
    reg    Q;
    input  NOTIFIER_REG,
           CP,                                     // Clock.
           RB,                                     // Clear input 
           SB;
    
// FUNCTION : POSITIVE EDGE TRIGGERED TOGGLE FLIP FLOP WITH
//            ASYNCHRONOUS SET AND CLEAR ( ACTIVE LOW ) /STANDARD DRIVE ( Q OUTPUT UDP ).



    table
      //   CP    RB    SB        NOTIFIER_REG  :  QTN  :  QTN+1
           r     1     1            ?          :   0   :    1   ;     // Toggle condition.
           r     1     1            ?          :   1   :    0   ;   


           ?     0     1            ?          :   ?   :    0   ;     //asynchronous reset.
           ?     ?     0            ?          :   ?   :    1   ;     //asynchronous set.
                         
          (?0)   1     1            ?          :   ?   :    -   ;
          (1x)   1     1            ?          :   ?   :    -   ;
           ?    (?1)   ?            ?          :   ?   :    -   ;
           ?     ?    (?1)          ?          :   ?   :    -   ;

           r     x     1            ?          :   1   :    0   ;     // pessimism
           r     1     x            ?          :   0   :    1   ;     // pessimism  
           ?     x     1            ?          :   0   :    0   ;
           ?     1     x            ?          :   1   :    1   ;
           ?     ?     ?            *          :   ?   :    x   ;

    endtable

endprimitive
